/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.collections.JoinedList;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.ImportantBlocks;
import com.moulberry.axiom.utils.WeirdTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class BlockList {
    private boolean needsReload = true;
    private String lastSearch = "";
    private Predicate<CustomBlockState> lastFilter = null;
    private List<Entry> searchedBlocks;
    private List<TagEntry> searchedTags;
    private final List<Entry> blocksStartsWith = new ArrayList<Entry>();
    private final List<Entry> blocksContains = new ArrayList<Entry>();
    private final List<TagEntry> tagsStartsWith = new ArrayList<TagEntry>();
    private final List<TagEntry> tagsContains = new ArrayList<TagEntry>();
    private List<Entry> blocksAll = List.of();
    private List<Entry> blocksAllLengthSorted;
    private List<TagEntry> tagsAll;
    private List<TagEntry> tagsAllLengthSorted;

    public BlockList() {
        this.searchedBlocks = this.blocksAll;
        this.blocksAllLengthSorted = List.of();
        this.tagsAll = List.of();
        this.searchedTags = this.tagsAll;
        this.tagsAllLengthSorted = List.of();
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                this.markNeedsReload();
            }
        });
    }

    public void markNeedsReload() {
        this.needsReload = true;
    }

    private void doReload() {
        this.needsReload = false;
        ArrayList<Entry> blocksAll = new ArrayList<Entry>();
        HashSet<class_2248> processedBlocks = new HashSet<class_2248>();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            boolean bl = class_7706.method_47330((class_7699)player.field_3944.method_45735(), (player.method_7338() && (Boolean)class_310.method_1551().field_1690.method_47395().method_41753() != false ? 1 : 0) != 0, (class_7225.class_7874)player.method_37908().method_30349());
        }
        for (class_2248 class_22482 : ImportantBlocks.IMPORTANT_BLOCKS) {
            BlockList.addBlockToAll(blocksAll, processedBlocks, class_22482, true);
        }
        for (Map.Entry entry2 : ServerCustomBlocks.customBlockMap.entrySet()) {
            CustomBlockState state = ((CustomBlock)entry2.getValue()).defaultCustomState();
            String name = AxiomI18n.get(((CustomBlock)entry2.getValue()).translationKey());
            Entry entry22 = new Entry(state, (class_2960)entry2.getKey(), BlockList.createSearchKey(name), ((CustomBlock)entry2.getValue()).translationKey());
            blocksAll.add(entry22);
        }
        for (class_1799 class_17992 : class_7706.method_47344().method_45414()) {
            class_2248 block = class_2248.method_9503((class_1792)class_17992.method_7909());
            BlockList.addBlockToAll(blocksAll, processedBlocks, block, false);
        }
        for (class_2248 class_22483 : class_7923.field_41175) {
            BlockList.addBlockToAll(blocksAll, processedBlocks, class_22483, false);
        }
        this.blocksAll = Collections.unmodifiableList(blocksAll);
        this.searchedBlocks = this.blocksAll;
        ArrayList<Entry> blocksAllLengthSorted = new ArrayList<Entry>(blocksAll);
        blocksAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.blocksAllLengthSorted = Collections.unmodifiableList(blocksAllLengthSorted);
        List<TagEntry> list = class_7923.field_41175.method_40272().sorted(Comparator.comparing(o -> WeirdTags.isWeird((class_6862<class_2248>)((class_6862)o.getFirst()))).thenComparing(o -> !((class_6862)o.getFirst()).comp_327().method_12836().equals("axiom")).thenComparingInt(o -> -((class_6885.class_6888)o.getSecond()).method_40247()).thenComparing(o -> ((class_6862)o.getFirst()).comp_327().method_12832())).map(e -> new TagEntry((class_6885<class_2248>)((class_6885)e.getSecond()), ((class_6862)e.getFirst()).comp_327(), BlockList.createSearchKey(((class_6862)e.getFirst()).comp_327().toString()))).toList();
        this.tagsAll = list;
        this.searchedTags = this.tagsAll;
        ArrayList<TagEntry> tagsAllLengthSorted = new ArrayList<TagEntry>(list);
        tagsAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.tagsAllLengthSorted = Collections.unmodifiableList(tagsAllLengthSorted);
        this.lastSearch = "";
        this.lastFilter = null;
    }

    private static void addBlockToAll(ArrayList<Entry> all, Set<class_2248> processedBlocks, class_2248 block, boolean allowAir) {
        if (processedBlocks.contains(block)) {
            return;
        }
        if (!allowAir && block.method_9564().method_26215()) {
            return;
        }
        if (block instanceof class_2667) {
            return;
        }
        Entry entry = BlockList.createEntry(block.method_9564());
        all.add(entry);
        processedBlocks.add(block);
    }

    public static Entry createEntry(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        class_2960 location = class_7923.field_41175.method_10221((Object)block);
        CustomBlockState state = (CustomBlockState)BlockList.overrideDefaultState(blockState);
        String name = AxiomI18n.get(block.method_9539());
        return new Entry(state, location, BlockList.createSearchKey(name), block.method_9539());
    }

    private static String createSearchKey(String string) {
        StringBuilder searchKey = new StringBuilder();
        for (char c : string.toLowerCase(Locale.ROOT).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            searchKey.append(c);
        }
        return searchKey.toString();
    }

    private static class_2680 overrideDefaultState(class_2680 state) {
        if (state.method_28498((class_2769)class_2397.field_11200)) {
            state = (class_2680)state.method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void search(String search) {
        this.search(search, null);
    }

    public void search(String search, Predicate<CustomBlockState> filter) {
        Object searchF;
        if (this.needsReload) {
            this.doReload();
        }
        if ((search = BlockList.createSearchKey(search)).equals(this.lastSearch) && filter == this.lastFilter) {
            return;
        }
        if (search.isBlank()) {
            if (filter != null) {
                this.searchedBlocks = new ArrayList<Entry>();
                for (Entry entry : this.blocksAll) {
                    if (!filter.test(entry.state)) continue;
                    this.searchedBlocks.add(entry);
                }
            } else {
                this.searchedBlocks = this.blocksAll;
            }
            this.searchedTags = this.tagsAll;
            this.lastSearch = search;
            this.lastFilter = filter;
            return;
        }
        if (!(this.searchedBlocks instanceof JoinedList) || !search.startsWith(this.lastSearch) || filter != this.lastFilter) {
            this.blocksStartsWith.clear();
            this.blocksContains.clear();
            for (Entry entry : this.blocksAllLengthSorted) {
                if (filter != null && !filter.test(entry.state)) continue;
                if (entry.searchKey.startsWith(search)) {
                    this.blocksStartsWith.add(entry);
                    continue;
                }
                if (!entry.searchKey.contains(search)) continue;
                this.blocksContains.add(entry);
            }
            this.searchedBlocks = new JoinedList<Entry>(this.blocksStartsWith, this.blocksContains);
        } else {
            searchF = search;
            this.blocksContains.removeIf(arg_0 -> BlockList.lambda$search$8((String)searchF, arg_0));
            this.blocksStartsWith.removeIf(arg_0 -> this.lambda$search$9((String)searchF, arg_0));
        }
        if (this.searchedTags == this.tagsAll || !search.startsWith(this.lastSearch)) {
            this.tagsStartsWith.clear();
            this.tagsContains.clear();
            for (TagEntry tagEntry : this.tagsAllLengthSorted) {
                if (tagEntry.searchKey.startsWith(search)) {
                    this.tagsStartsWith.add(tagEntry);
                    continue;
                }
                if (!tagEntry.searchKey.contains(search)) continue;
                this.tagsContains.add(tagEntry);
            }
            this.searchedTags = new JoinedList<TagEntry>(this.tagsStartsWith, this.tagsContains);
        } else {
            searchF = search;
            this.tagsContains.removeIf(arg_0 -> BlockList.lambda$search$10((String)searchF, arg_0));
            this.tagsStartsWith.removeIf(arg_0 -> this.lambda$search$11((String)searchF, arg_0));
        }
        this.lastSearch = search;
        this.lastFilter = filter;
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public List<Entry> getBlocks() {
        if (this.needsReload) {
            this.doReload();
        }
        return this.searchedBlocks;
    }

    public List<TagEntry> getTags() {
        if (this.needsReload) {
            this.doReload();
        }
        return this.searchedTags;
    }

    private /* synthetic */ boolean lambda$search$11(String searchF, TagEntry entry) {
        if (entry.searchKey.startsWith(searchF)) {
            return false;
        }
        if (entry.searchKey.contains(searchF)) {
            this.tagsContains.add(entry);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$search$10(String searchF, TagEntry entry) {
        return !entry.searchKey.contains(searchF);
    }

    private /* synthetic */ boolean lambda$search$9(String searchF, Entry entry) {
        if (entry.searchKey.startsWith(searchF)) {
            return false;
        }
        if (entry.searchKey.contains(searchF)) {
            this.blocksContains.add(entry);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$search$8(String searchF, Entry entry) {
        return !entry.searchKey.contains(searchF);
    }

    public record Entry(CustomBlockState state, class_2960 location, String searchKey, String translationKey) {
    }

    public record TagEntry(class_6885<class_2248> set, class_2960 location, String searchKey) {
    }
}

